<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\Config;
use Mnv\Core\Design;
use Mnv\Http\Request;

/**
 * Class IndexAdmin
 * @package Mnv\Admin\Controllers
 */
class IndexAdmin
{
    /** @var mixed $module */
    private $backendController;

    /** IndexAdmin constructor.
     *
     * @throws \Exception
     */
    public function __construct(Design $smarty)
    {

        /* language functions */
        $admin_language = Config::getValue('admin_language');
        loadLanguage($admin_language);
        $smarty->assign('adminLang', $admin_language);
        $smarty->assign('jsLang', langJs('javascript'));
        try {
            $smarty->registerFilter(\Smarty::FILTER_PRE, 'replaceLanguageTags', null);
        } catch (\SmartyException $e) {
            print $e->getMessage();
        }

        $smarty->compile_check   = \Smarty::COMPILECHECK_CACHEMISS;
        $smarty->setCompileDir($smarty->tmpPath() . 'compile');
        $smarty->setCompileId('admin-' . $admin_language);
        $smarty->setTemplateDir($smarty->defaultAdminTemplateDir());
        $smarty->debugging = false;

        /** получаем модуль */
        $backendControllerName = request('mod');
        $backendControllerName = preg_replace("/[^a-z]+/", "", $backendControllerName);

//            var_dump($backendControllerName);

        if (!empty($backendControllerName)) {

            /** получение модуля */
            $moduleControllerName = $this->searchModule($backendControllerName);

//            var_dump($moduleControllerName);

            if (!file_exists(GLOBAL_ROOT. "/admin/Controllers/".$moduleControllerName.'.php')) {
                throw new \Exception("File not found - $moduleControllerName.php");
            }

            /** Подключаем файл с необходимым модулем */
            require_once  $moduleControllerName.'.php';
            /** Создаем соответствующий модуль */
            $moduleControllerClass =  '\\Mnv\\Admin\\Controllers\\' . $moduleControllerName;

            if (class_exists($moduleControllerClass)) {
                $this->backendController = new $moduleControllerClass();
            } else {
                // можно создать шаблон с выводом информацией о том что забыли создать класс, файл скопировали он существует с таким названием а самого класса нету
                die("Error creating $moduleControllerName class");
            }
        } else {
            redirect('/admin/auth');
        }

//        print_r($this);
    }


    /** Отображение запрашиваемого модуля */
    public function fetch()
    {
        global $smarty;

        $contents = $this->backendController->fetch();
        if ($this->backendController === 'AuthAdmin' || $this->getPermissionByController(get_class($this->backendController)) === 'auth') {
            $smarty->assign("content", false);
        } else {
            $smarty->assign("content", $contents);
        }

        /** Создаем текущую обертку admin (index.tpl) */
        $wrapper = $smarty->getTemplateVars('wrapper');
        if (is_null($wrapper)) {
            $wrapper = 'index.tpl';
        }

        /** Проверяем нам передали итоговую HTML или имя файла шаблона */
        if (!empty($wrapper)) {
            try {
                return $smarty->fetch($wrapper);
            } catch (\SmartyException | \Exception $e) {
                return $e->getMessage();
            }
        }

        return $contents;
    }

    /**
     * получаем контроллер
     *
     * @param $controller
     * @return false|mixed
     */
    public function getPermissionByController($controller)
    {
        $controllersPermissions = $this->getControllersPermissions();

        return $controllersPermissions[$controller] ?? false;
    }

    /**
     * получаем все контроллеры
     *
     * @return mixed
     */
    public function getControllersPermissions()
    {
        $modulesPermissions = include GLOBAL_ROOT.'/admin/config/modules.permissions.inc.php';
        $controllersPermissions = $modulesPermissions;
        foreach ($modulesPermissions as $controller => $modulePermission)  {
            $controllersPermissions[$controller] = $modulePermission;
        }

        return $controllersPermissions;
    }

    /**
     * Поиск модуля
     *
     * @param $module
     * @return int|string
     */
    public function searchModule($module)
    {
        //TODO: Доработать метод чтоб не пользоваться (modules_permissions)
        $modulesPermissions = include GLOBAL_ROOT.'/admin/config/modules.permissions.inc.php';
        foreach ( $modulesPermissions as $model => $permission ) {
            if ( is_array($permission) ) {
                foreach ( $permission as $subPermission ) {
                    if (in_array($module, $permission, true) && $module == $subPermission) {
                        return $model;
                    }
                }
            }
            if (in_array($module, $modulesPermissions, true) && ($module == $permission)) {
                return $model;
            }

        }

        return 'PageError';
    }


}