<form method="post">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/currencies"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/currencies" class="breadcrumb-item">{$title}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">
        <div class="row"> 
            <div class="col-md-12">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
		                    <div class="row">
			                    <div class="col-md-6">
			                        <div class="form-group mb-3">
			                            <label class="form-label is-visible {if isset($errors.titleNull)}text-danger{/if}" >{currency:form:title}</label>
			                            <input type="text" class="form-control" name="currency[title]" value="{if isset($currency.title)}{$currency.title}{/if}">
			                        </div>
			                    </div>
			                    <div class="col-md-6">
			                        <div class="form-group mb-3">
			                            <label class="form-label is-visible {if isset($errors.titleNull)}text-danger{/if}">{currency:form:codeName}</label>
			                            <input type="text" class="form-control" name="currency[codeName]" value="{if isset($currency.codeName)}{$currency.codeName}{/if}" />
			                        </div>
			                    </div>
			                    <div class="col-md-4">
			                        <div class="form-group mb-3">
			                            <label class="form-label is-visible {if isset($errors.course)}text-danger{/if}">{currency:form:course}</label>
			                            <input  type="text" class="form-control" name="currency[course]" value="{if isset($currency.course)}{$currency.course}{/if}" />
			                        </div>
			                    </div>
			                    <div class="col-md-4">
			                        <div class="form-group mb-3">
			                            <label class="form-label is-visible">Отображение копеек</label>
			                            <select class="form-control select" name="currency[cent]">
			                                <option value="2" {if isset($currency.cent) && $currency.cent == 2}selected{/if}>Да</option>
			                                <option value="0" {if isset($currency.cent) && $currency.cent == 0}selected{/if}>Нет</option>
			                            </select>
			                        </div>
			                    </div>
			                    <div class="col-md-4">
			                        <div class="form-group mb-3">
			                            <label class="form-label is-visible">Разделитель тысяч</label>
			                            <select class="form-control select" name="currency[thousands_separator]">
			                                <option value=""  {if isset($currency.thousands_separator) && $currency.thousands_separator == ''}selected{/if}>без разделителя: 1245678</option>
			                                <option value=" " {if isset($currency.thousands_separator) && $currency.thousands_separator == ' '}selected{/if}>пробел: 1 245 678</option>
			                                <option value="," {if isset($currency.thousands_separator) && $currency.thousands_separator == ','}selected{/if}>запятая: 1,245,678</option>
			                                <option value="." {if isset($currency.thousands_separator) && $currency.thousands_separator == '.'}selected{/if}>точка: 1.245.678</option>
			                            </select>
			                        </div>
			                    </div>
		                    </div>

	                    </div>
			        </div>
    		    </div>
            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>


<script>
    $(document).ready(function () {
        {if isset($errors.titleNull)} new Noty({ text: '{currency:errors:titleNull}', type: 'error' }).show(); {/if}
        {if isset($errors.codeNameNull)} new Noty({ text: '{currency:errors:codeNameNull}', type: 'error' }).show(); {/if}
        {if isset($errors.course)} new Noty({ text: '{currency:errors:courseNull}', type: 'error' }).show(); {/if}
      
        {if isset($messages.saved)} new Noty({ text: '{currency:messages:saved}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{currency:messages:deleted}', type: 'success' }).show(); {/if}
    });               
</script>
