
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/country?action=add?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/countries" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/countries"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="countries">
						<thead>
						<tr>
							<th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
							<th data-toggle="true">Название города</th>
							<th data-hide="phone" class="text-center">{general:status}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($countries)}
							<tbody class="selectable-demo-list">
                            {foreach item=country from=$countries name=countries}
								<tr id="countrie-{$country.id}" data-id="{$country.id}" class="{if $country.status eq 'H'}table-warning{/if}">
									<td class="text-start text-nowrap">{$country.id}</td>
									<td class="text-start" width="100%"> {$country.name nofilter}</td>
									<td class="text-center" id="status-{$country.id}" >{$country.statusName nofilter}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/country?action=edit&id={$country.id}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-right">
													<a class="dropdown-item" href="{$adminUrl}/country?action=edit&id={$country.id}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													<button class="dropdown-item ajax_action" id="article-status-{$country.id}" data-module="countries" data-action="status" data-id="{$country.id}"><i class="{if $country.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
													<div class="dropdown-divider"></div>
													<button class="dropdown-item text-danger" onclick="newRemove({$country.id}, '{$country.name}', 'countries');"><i class="ph-trash me-2"></i> {general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>

                {include file="module/pagination.tpl" url="{$adminUrl}/countries" params="{$buildQueryString}"}

			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
        {if isset($errors.not_saved)} new Noty({ text: 'Страна НЕ сохранена', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Страна сохранена', type: 'success', timeout: 1500 }).show(); {/if}
    });


</script>




