
	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/errors" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/errors"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					{include file="components/selectors.tpl" action="{$adminUrl}/errors" select="errors"}
				</div>
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h5 class="mb-0">{$title}</h5>
						<div class="d-inline-flex ms-auto">
							<ul class="list-inline list-inline-dotted mb-0">
								<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">404</span> - <span class="text-danger font-size-sm">{stats:errorCodes:404}</span></li>
								<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">503</span> - <span class="text-danger font-size-sm">{stats:errorCodes:503}</span></a></li>
								<li class="list-inline-item"><span class="text-danger font-size-sm font-weight-semibold">301</span> - <span class="text-danger font-size-sm">{stats:errorCodes:301}</span></a></li>
							</ul>
						</div>
					</div>
					<div class="">
						<table class="table table-xs table-striped table-actions table-hover">
							<thead>
							<tr>
								<th class="text-center" width="100">{stats:code}</th>
								<th class="text-left">{stats:requestUri}</th>
							</tr>
							</thead>
							{if isset($errors) && !empty($errors)}
								<tbody>
								{foreach item=error from=$errors}
									<tr>
										<td class="code{$error.errorCode}" align="center">{$error.errorCode}</td>
											<td class="" width="100%"><a href="{$adminUrl}/error?requestUri={$error.requestUri nofilter}">{$error.requestUri|truncate:80|escape}</a></td></tr>
								{/foreach}
								</tbody>
							{else}
								<tbody> <tr class="odd"><td class="text-center" colspan="2">- {general:none} -</td></tr></tbody>
							{/if}

						</table>
					</div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/errors" params="{if isset($filterErrorCode)}&filterErrorCode={$filterErrorCode}{/if}"}
				</div>


			</div>
		</div>
	</div>
	<!-- /content area -->
