
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary mx-1" data-bs-popup="tooltip" title="{general:add} группу" data-bs-placement="auto" href="{$adminUrl}/managergroup?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
{/capture}
{capture name="breadcrumb"}
	<a href="{$adminUrl}/managergroups" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/manager-groups"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover users-archive" id="managergroups">
						<thead>
						<tr>
							<th width="160">Дата изменения</th>
							<th class="">Название</th>
							<th class="">Участники группы</th>
							<th class="text-center">{general:status}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if isset($groups)}
							<tbody>
                            {foreach item=group from=$groups name=groups}
								<tr id="managergroup-{$group.groupId}" class="{if $group.status eq 'H'}table-warning{/if}">
									<td class="text-left text-nowrap"><span class="fs-sm fw-semibold">{$group.dateChange}</span></td>
									<td class="">{$group.groupName nofilter}</td>
									<td class=""><span class="fw-semibold">{$group.countUsers|default:0}</span> <span class="fs-sm">({$group.countUsers|plural:'по...ль':'по...лей':'по...ля'|lower})</span></td>
									<td id="status-{$group.groupId}" class="text-center">{$group.statusName nofilter}</td>
									<td class="text-left">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/managergroup?action=edit&id={$group.groupId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
                                            {if !$smarty.foreach.groups.first}
												<div class="dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/managergroups?action=edit&id={$group.groupId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														<button class="dropdown-item ajax_action" data-module="managergroups" data-action="status" data-id="{$group.groupId}"><i class="{if $group.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
														<div class="dropdown-divider"></div>
														<button class="dropdown-item text-danger" onclick="newRemove({$group.groupId}, '{$group.groupName}', 'managergroups')"><i class="ph-trash me-2"></i> {general:delete}</button>
													</div>
												</div>
                                            {/if}
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/managergroups" params="{$buildQueryString}"}

			</div>
		</div>

	</div>
</div>

<script>
    $(document).ready(function () {

        {if isset($errors.name_empty)}     new Noty({ text: '{managers:errors:13}', type: 'error' }).show(); {/if}
        {if isset($errors.name_exists)}    new Noty({ text: '{managers:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.user_not_found)}  new Noty({ text: '{managers:errors:1}', type: 'error' }).show();  {/if}

        {if isset($errors.not_saved)}       new Noty({ text: '{managers:errors:5}', type: 'error' }).show(); {/if}

        {if isset($errors.privileges_empty)} new Noty({ text: 'У группы пользователей должна быть хотя бы одна привилегия.', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{managers:messages:0}', type: 'success' }).show(); {/if}
    });

</script>

