<?php

namespace Mnv\Core\Sms;

use Mnv\Core\Config;

/**
 *  Class SmsGateway
 *
 * @package Mnv\Core\Sms
 */
abstract class SmsGateway
{

    /** @var string $sendUrl  */
    protected string $endpoint = '';

    /** @var string $smsLogin  */
    protected string $smsLogin = '';

    /** @var string $smsPass */
    protected string $smsPass = '';

    /** @var string $nickname */
    protected string $nickname = '';

    protected $sms = [];

    public function __construct()
    {
        $this->endpoint = Config::getValue('sms_endpoint');
        $this->smsLogin = Config::getValue('sms_login');
        $this->smsPass  = Config::getValue('sms_password');
    }
    /**
     * @param $phone
     * @return array|string|string[]|null
     */
    public function formatPhoneNumber($phone)
    {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        return preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);
    }

}