<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Payments
 * @package Mnv\Models
 */
class Payments extends Model
{

    /** @var string */
    protected string $table = 'shop_payments';

    /** @var string  */
    protected string $primaryKey = 'paymentId';

    protected string $orderBy = 'orderBy ASC';

    public $paymentIds;

    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');                  //  getRequestVar('id'),
        $this->data         = $request->get('payment', '');  //  getRequestVar('payment', '', true)
        $this->paymentIds   = $request->get('ids', '');      // getRequestVar('ids', '', true);
    }

    /**
     * Проверка на совпадение и получение fileName
     *
     * @param string|null $fileName
     * @return mixed|string|null
     */
    public function checkFileName(?string $fileName)
    {
        if (!empty($this->id)) connect()->where($this->primaryKey,'<>', $this->id);
        if ($fileName = connect()->table($this->table)->select('fileName')->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
            return $fileName;
        }

        return null;
    }


    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    public function getPaymentModules(): array
    {
        $modulesDir = GLOBAL_ROOT.'/app/Modules/Payment/';

        $modules = array();
        $handler = opendir($modulesDir);
        while ($dir = readdir($handler))
        {
            $dir = preg_replace("/[^A-Za-z0-9]+/", "", $dir);
            if (!empty($dir) && $dir != "." && $dir != ".." && is_dir($modulesDir.$dir)) {

                if (is_readable($modulesDir . $dir .'/settings.xml') && $xml = simplexml_load_file($modulesDir . $dir . '/settings.xml')) {
                    $objJsonDocument = json_encode($xml);
                    $xml = json_decode($objJsonDocument, TRUE);

                    $module['name'] = (string)$xml['name'];
                    $module['settings'] = array();

                    foreach($xml['settings'] as $setting) {
                        $module['settings'][$setting['variable']]['name'] = $setting['name'];
                        $module['settings'][$setting['variable']]['variable'] = $setting['variable'];
                        $module['settings'][$setting['variable']]['variable_options'] = array();
                        if (isset($setting['options'])) {
                            foreach ($setting['options'] as $option) {
                                $module['settings'][$setting['variable']]['options'][$option['value']]['name'] = $option['name'];
                                $module['settings'][$setting['variable']]['options'][$option['value']]['value'] = $option['value'];
                            }
                        }
                    }
                    $modules[$dir] = $module;
                }

            }
        }
        closedir($handler);

//        print_r($modules);

        return $modules;
    }

}