<?php

namespace Mnv\Models\Users;

/**
 * Class UserTypes
 * @package Mnv\Models\Users
 */
class UserTypes
{
    const ADMIN         = 'A';
    const DEVELOPER     = 'D';
    const MANAGER       = 'M';
    const CUSTOMER      = 'C';
    const SUBSCRIBER    = 'S';

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isDeveloper(string $user_type): bool
    {
        return $user_type === self::DEVELOPER;
    }
    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isAdmin(string $user_type): bool
    {
        return $user_type === self::ADMIN;
    }

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isManager(string $user_type): bool
    {
        return $user_type === self::MANAGER;
    }

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isCustomer(string $user_type): bool
    {
        return $user_type === self::CUSTOMER;
    }

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isSubscriber(string $user_type): bool
    {
        return $user_type === self::SUBSCRIBER;
    }

}