<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_stations($params, &$smarty) {
	global $fetchedProjects;

	$assign        = fetch_getParam('assign', $params, 'stations');
	$fields        = fetch_getParam('fields', $params, 'stationId, sectionId, orderBy, publishedOn, title, alias, landmark, coordinates, url, summary, isFeatured, orderBy');
	$status        = fetch_getParam('status', $params, 'V');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
	$countryId      = fetch_getParam('country', $params);
    $stationId     = fetch_getParam('stationId', $params);
	$page          = (int) fetch_getParam('page', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

	$image        = fetch_getParam('image', $params, false);
	$imageType    = fetch_getParam('imageType', $params, 'general');
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_articles: "assign" must not be empty');
		return;
	}
	
	if (empty($path)) $path = array();

	/** conditions */
    filterStation($status, $isFeatured, $stationId, $orderBy, $query, $countryId);

    if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

    /** query conditions */
    fetch_stations_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_stations_addSectionConditions($section, $noSubsections);
    /** checking article fields */
    fetch_stations_filterFields($fields);

	if ($page < 1) $page = 1;
	if ($perPage < 1) $perPage = 10;

	if (!is_null($query) && empty($query)) {
		$projects = array();
	} else {
        $projects = connect('stations')->select($fields)->pagination($perPage, $page)->getAll('array');
//            print_r(connect()->getQuery());
        $projects = prepareStations($projects, $image, $imageType);
	}

//	print_r($projects);
	$smarty->assign($assign, $projects);

	/* saving fetched articles for SKIP ability */
	if(empty($fetchedProjects[$assign])) $fetchedProjects[$assign] = array();
	if(!empty($articles)) foreach ($articles as $article) $fetchedProjects[$assign][] = $article['projectId'];
	
	if (!empty($assignPagination)) {
        /** conditions */
        filterStation($status, $isFeatured, $stationId, $orderBy, $query, $countryId);

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        /** query conditions */
        fetch_stations_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_stations_addSectionConditions($section, $noSubsections);
        /** checking article fields */
        fetch_stations_filterFields($fields);

        /** page numbering */
        $total = connect('stations')->countDistinct('projectId')->getValue();
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}

function filterStation($status, $isFeatured, $stationId, $orderBy, $query, $countryId)
{
    global $gmNow;

    connect()->where('publishedOn','<=', $gmNow);
    if (!empty($status)) connect()->where('status', $status);
    if (!is_null($isFeatured)) connect()->where('isFeatured',$isFeatured ? 1 : 0);
    if (!empty($stationId)) connect()->where('stationId', '!=', $stationId);
    if (!empty($countryId)) connect()->where('countryId', $countryId);
    if (is_null($orderBy)) {
        connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
    } else {
        connect()->orderBy($orderBy);
    }
}

?>