<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}
	{* recaptcha - ОБЯЗАТЕЛЬНО *}
	{include file="modules/recaptcha.tpl"}
	{* /recaptcha - ОБЯЗАТЕЛЬНО *}
</head>

<body>
	
{if isset($section) && $section.sectionId eq 1}
<header class="header @seletor">
{else}
<header class="header sticky">
{/if}
	
	{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}

	<div class="header__item">

		<div class="social">
			{include file="modules/socials.tpl" path="/images/icons/social/"}
		</div>

		<div class="header__phones">
			{assign var=phones value=", "|explode:$config.phone}
			{foreach from=$phones item=phone name=phones}
				<a href="tel:{$phone|strip_phone}">{$phone|format_phone|replace:"+998 ":""}</a>
			{/foreach}
		</div>

	</div>

	<div class="header__item">

		{* <a class="header__logo" href="{$SITE_URL}">
			<img src="{$ASSETS_URL}/images/icons/logo/logo.png" alt="{$config.website_name}">
		</a> *}
        {logo link=true classLink="header__logo"}

		<nav class="header__nav">
			<ul>
				{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
					<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}#{$headerMenu.fileName}{/if}">{$headerMenu.name}</a></li>
				{/foreach}
			</ul>
		</nav>

		<div class="header__lang">

			<ul>
				<li>
					<span>
						Ру
					</span>

				{*	<ul>
						<li>
							<a href="">Uz</a>
						</li>
						<li>
							<a href="">En</a>
						</li>
					</ul>  *}

				</li>
			</ul>

		</div>

		<button class="header__btn header-btn_js">
			<span class="burger-btn burger-btn_short">
				<span class="burger-btn__item"></span>
			</span>
		</button>

	</div>

	<div class="header-mob header-mob_js">
		<div class="header-mob__inner">

			<div class="header-mob__head">

				{* <a class="header__logo" href="{$SITE_URL}">
					<img src="{$ASSETS_URL}/images/icons/logo/logo.png" alt="{$config.website_name}">
				</a> *}
                {logo link=true classLink="header__logo"}

			</div>

			<div class="header-mob__content">

				<div class="header-mob__nav">
					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}#{$headerMenu.fileName}{/if}">{$headerMenu.name}</a></li>
						{/foreach}
					</ul>
				</div>

			</div>

			<div class="header-mob__footer">

				<div class="header-mob__contacts">

					<ul>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone|replace:"+998 ":""}</a></li>
						{/foreach}
						<li><a href="mailto:{$config.email}">{$config.email}</a></li>
						<li>{$config.address}</li>
					</ul>

				</div>

				<div class="social accent-3">
					{include file="modules/socials.tpl" path="/images/icons/social/"}
				</div>

			</div>

		</div>
	</div>

</header>